/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm8275;

import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.ConfigChangeDetector;
import ibm.nways.jdm.modelgen.LocalModel;
import ibm.nways.ras.RAS;
import java.util.Vector;

public class UFCChangeDetector
implements ConfigChangeDetector {
    private static int maxports = 27;
    int[] oldPortTypes = new int[maxports];
    int[] newPortTypes = new int[maxports];
    public static final int RASID = 4;
    public static final int RASSUB = 7;
    boolean shouldinit = true;
    boolean gotTimeout = false;
    int phase;
    LocalModel pConfigPort;

    public void init(LocalModel localModel) {
        String string = "init";
        if (RAS.isEnabled(4, 7)) {
            RAS.enter(4, 7, this, string);
        }
        this.oldPortTypes = this.counter(localModel);
        if (!this.gotTimeout) {
            this.shouldinit = false;
        }
        if (RAS.isEnabled(4, 7)) {
            RAS.exit(4, 7, this, string);
        }
    }

    public int[] counter(LocalModel localModel) {
        int[] nArray = new int[maxports];
        String string = "counter";
        if (RAS.isEnabled(4, 7)) {
            RAS.enter(4, 7, this, string);
        }
        try {
            if (this.pConfigPort == null) {
                this.pConfigPort = localModel.getComponent("PortCfg");
                if (this.pConfigPort == null) {
                    this.pConfigPort = localModel.getComponent("PortCfg2");
                    if (this.pConfigPort != null) {
                        this.phase = 1;
                        if (RAS.isEnabled(4, 7)) {
                            RAS.trace(4, 7, this, string, "This is a BB II box");
                        }
                    } else {
                        this.phase = 0;
                        if (RAS.isEnabled(4, 7)) {
                            RAS.trace(4, 7, this, string, "Can not distinguish whether it is a BB I or BB II box  because the port tables are NULL !");
                        }
                    }
                } else {
                    this.phase = 1;
                    if (RAS.isEnabled(4, 7)) {
                        RAS.trace(4, 7, this, string, "This is a BB I box");
                    }
                }
            }
            if (this.phase == 1) {
                Vector vector = this.pConfigPort.getRestOfInfo("Graphics", "default", null, null);
                int n = 0;
                while (n < vector.size()) {
                    ModelInfo modelInfo = (ModelInfo)vector.elementAt(n);
                    if (modelInfo.timeoutDetected) {
                        this.gotTimeout = true;
                    } else {
                        int n2 = (Integer)modelInfo.get("Index.Port");
                        nArray[n2 - 1] = (Integer)modelInfo.get("Graphics.SwPortCfgPortIfType");
                    }
                    ++n;
                }
            }
        }
        catch (Exception exception) {
            this.shouldinit = true;
            if (RAS.isEnabled(4, 7)) {
                RAS.trace(4, 7, this, string, "problem getting models");
            }
            RAS.logException(4, 7, this, string, exception);
        }
        if (RAS.isEnabled(4, 7)) {
            RAS.exit(4, 7, this, string);
        }
        return nArray;
    }

    public boolean configChanged(LocalModel localModel) {
        String string = "configChanged";
        if (RAS.isEnabled(4, 7)) {
            RAS.enter(4, 7, this, string);
        }
        if (this.phase < 2) {
            if (this.shouldinit) {
                this.init(localModel);
                if (RAS.isEnabled(4, 7)) {
                    RAS.trace(4, 7, this, string, "Had to init ");
                    RAS.exit(4, 7, this, string);
                }
                return false;
            }
            this.gotTimeout = false;
            this.newPortTypes = this.counter(localModel);
            if (this.gotTimeout) {
                if (RAS.isEnabled(4, 7)) {
                    RAS.trace(4, 7, this, string, "timeout received - no detection process this poll");
                    RAS.exit(4, 7, this, string);
                }
                return false;
            }
            int n = 0;
            while (n < maxports) {
                if (RAS.isEnabled(4, 7)) {
                    RAS.trace(4, 7, this, string, " old:" + this.oldPortTypes[n] + " new:" + this.newPortTypes[n]);
                }
                if (this.newPortTypes[n] != this.oldPortTypes[n]) {
                    this.oldPortTypes = this.newPortTypes;
                    if (RAS.isEnabled(4, 7)) {
                        RAS.trace(4, 7, this, string, "Detected a change in the port types , there must have been a UFC transaction");
                        RAS.exit(4, 7, this, string);
                    }
                    return true;
                }
                ++n;
            }
        }
        if (RAS.isEnabled(4, 7)) {
            RAS.exit(4, 7, this, string);
        }
        return false;
    }

    public void dispose() {
        this.pConfigPort = null;
    }
}

